% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateOutputFileName.R
\name{CreateOutputFileName}
\alias{CreateOutputFileName}
\title{CreateOutputFileName}
\usage{
CreateOutputFileName(inputFileName, outputPath = dirname(inputFileName),
  prefix = "", suffix = "", extension = "txt")
}
\arguments{
\item{inputFileName}{Input file name. Required.}

\item{outputPath}{Output path for the file. Optional.
Default = \code{\link{dirname}(inputFileName)}.}

\item{prefix}{String to add at the beginning of the file name. Optional. Default = "".}

\item{suffix}{String to add at end beginning of the file name. Optional. Default = "".}

\item{extension}{File extension. Optional. Default = "txt".}
}
\value{
File name
}
\description{
Create output file name based on the input file name.
}
\examples{
CreateOutputFileName(inputFileName = "test.xlsx")
CreateOutputFileName(inputFileName = "C:/Files/test.xlsx")
CreateOutputFileName(inputFileName = "C:/Files/test.xlsx", prefix = "Output_")

}
