% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetParamWidgets.R
\name{GetParamWidgets}
\alias{GetParamWidgets}
\title{GetParamWidgets}
\usage{
GetParamWidgets(paramSpecs, params = NULL, skipParamNames = c(),
  ns = function(x) x)
}
\arguments{
\item{paramSpecs}{List of parameter specifications. Required.}

\item{params}{List of parameters. Optional. Default = NULL.}

\item{skipParamNames}{Vector of parameter names for which widgets are not to be created. Optional.
Default = c().}

\item{ns}{Function for creating namespace. It must return a string. Optional.
Default: \code{function(x) x}.}
}
\value{
List of Shiny html controls
}
\description{
Generates a list of Shiny widgets for all parameters specified in \code{paramSpecs}.
It is based on \code{\link[rmarkdown]{knit_params_ask}} function.
}
\examples{
paramSpecs <- list(
  nimp = list(
    name = "nimp",
    label = "Number of imputations",
    input = "numeric",
    value = 2L
  ),
  chk = list(
    name = "chk",
    label = "Checkbox",
    input = "select",
    choices = c("A" = "A", "B" = "B"),
    multiple = TRUE
  )
)
GetParamWidgets(paramSpecs)

}
