% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadDataFile.R
\name{ReadDataFile}
\alias{ReadDataFile}
\title{ReadDataFile}
\usage{
ReadDataFile(fileName, fileType, ...)
}
\arguments{
\item{fileName}{Name of file to read. Required.}

\item{fileType}{Type of data to read. Required if \code{fileName} has no file extension,
otherwise optional.}

\item{...}{Additional parameters passed to \code{\link{ReadExcelFile}} or
\code{\link{ReadTextFile}}. Optional.}
}
\value{
data.table object.
}
\description{
Read content of a data file, either Excel or text.\cr
It is a wrapper around \code{\link{ReadExcelFile}} and \code{\link{ReadTextFile}}. Appropriate
loading function is resolved by the extension of \code{fileName}.
}
\examples{
\dontrun{
ReadDataFile(fileName)
ReadDataFile(fileName, "xlsx")
ReadDataFile(fileName, "csv")
}

}
