% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RollingApply.R
\name{RollingApply}
\alias{RollingApply}
\title{RollingApply}
\usage{
RollingApply(data, width, func, ...)
}
\arguments{
\item{data}{Vector of observations. Required.}

\item{width}{Integer specifying the window width (in numbers of observations). Required.}

\item{func}{Function to be applied. Required.}

\item{...}{Additional arguments to be passed to \code{func}. Optional.}
}
\description{
Applies a function to a centered rolling window of data.
This is a simplified version of function \code{rollaplly} from package \code{zoo}.
}
\examples{
RollingApply(c(1, 2, 3, 4, 5), width = 3, func = sum)
RollingApply(c(1, 2, 3, 4, 5), width = 3, func = mean)
RollingApply(c(1, 2, 3, 4, 5), width = 3, func = sd)
RollingApply(c(1), width = 10, func = sd)
RollingApply(c(1), width = 10, func = mean)
RollingApply(c(), width = 10, func = sd)
RollingApply(c(), width = 10, func = mean)

}
