% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConvertDataTableColumns.R
\name{ConvertDataTableColumns}
\alias{ConvertDataTableColumns}
\title{ConvertDataTableColumns}
\usage{
ConvertDataTableColumns(object, columnDefs, levelsFunc = NULL, ...)
}
\arguments{
\item{object}{A data.table object whose column classes are to be converted}

\item{columnDefs}{A list of column class definitions in a form "[ColumnName] = [ColumnClass]"}

\item{levelsFunc}{Function used to initialize levels of factor columns. (def: NULL)}

\item{...}{Additional arguments passed to \code{levelsFunc}.}
}
\description{
Converts columns of a data.table object to specified classes.
The transformation is made by reference, thus the changes are made directly to the object
passed in and no copies are made.
}
\examples{
object <- data.table::data.table(RecordId = c("1", "2"), CD4 = c("233", "459"))
# Column definitions as named vector
columnDefs <- c(RecordId = "integer", CD4 = "numeric")
# Check class of columns before conversion
sapply(object, class)
ConvertDataTableColumns(object, columnDefs)
# Check class of columns after conversion
sapply(object, class)

}
