% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RenderReportToFile.R
\name{RenderReportToFile}
\alias{RenderReportToFile}
\title{RenderReportToFile}
\usage{
RenderReportToFile(
  reportFilePath,
  format = "html_fragment",
  outputFilePath = NULL,
  outDir = dirname(reportFilePath),
  ...
)
}
\arguments{
\item{reportFilePath}{Path to the source RMarkdown file. Required.}

\item{format}{Output format of the report. Optional. Default = \code{'html_fragment'}.}

\item{outputFilePath}{Path to the output file. Optional. Default = \code{NULL}.}

\item{outDir}{Output directory. Temporary directory is used if \code{NULL}. Optional.
Default = \code{\link{dirname}(reportFilePath)}.}

\item{...}{Additional arguments passed to \link[rmarkdown]{render}. Optional.}
}
\value{
File name of the generated report
}
\description{
Creates a report from a specified RMarkdown file.
}
\examples{
\dontrun{
RenderReportToFile(
  filePath,
  params = list(AdjustedData = data.table::data.table(A = c(1, 2), B = c(3, 4))))
}

}
\seealso{
\pkg{rmarkdown}
}
